-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/style.lua" );

MyFont = {
  standardFont,
  30,
  BlackColor
};

NameFont = {
  standardFont,
  20,
  BlackColor
};

kTitleY			= 50;
kFirstButtonY	= kCenter;
kButtonSpace	= 90;
kTextButton = 30;

MakeDialog
{
	name="endless",
	
	Bitmap
	{
		image="images/ui/common/popup02",
		x=kPopUpGeneralX,
		y=kPopUpGeneralY,
		
		Text
		{
			font	= PopupFont,
			name	= "endlesschoice",
			x=0,
			y=kTitleY,
			w=kMax,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = "endlessChoice"
		};
		SetStyle(FitnessButtonStyleTittleSmallBlue),
--Fitness Mode
		SBButton
		{
			x		= kCenter-kButtonSpace,
			y		= kFirstButtonY,
			
			name	= "FitnessMode",
			icon	= "assets/images/ui/buttons/icon/iconfitness",
			command =
				function()
				
					PopModal("endless");
					PopModal("mainmenu");
					SetCurrentGameMode(1);
					DoModal("scripts/metamap.lua");					
				end
		},
		Text
		{
			font	= SmallFont,
			x		= kCenter-kButtonSpace,
			y		= kFirstButtonY+kTextButton,
			flags	= kHAlignCenter + kVAlignCenter,
			label	= "FitnessMode",
		};
--Tug of war Mode
		SBButton
		{
			x		= kCenter,
			y		= kFirstButtonY,
			name	= "TugOfWarMode",
			
			icon	= "assets/images/ui/buttons/icon/icontug",
			command =
				function()

					PopModal("endless");
					PopModal("mainmenu");
					SetCurrentGameMode(4);
					DoModal("scripts/metamap.lua");					
				end
		};
		Text
		{
			font	= SmallFont,
			x		= kCenter,
			y		= kFirstButtonY+kTextButton,
			flags	= kHAlignCenter + kVAlignCenter,
			label	= "TugOfWarMode",
			w=100,
			h=100
		};
--BACK
		SBButton{
			x=kCenter+kButtonSpace,
			y=kFirstButtonY,
			name="back",
			
			icon="assets/images/ui/buttons/icon/iconback",
			command = 
				function()
					PopModal("endless");
				end
		};
		Text
		{
			font	= SmallFont,
			x		= kCenter+kButtonSpace,
			y		= kFirstButtonY+kTextButton,
			flags	= kHAlignCenter + kVAlignCenter,
			label="common.back.label",
		};
	},
}